/*
 * Decompiled with CFR 0.152.
 */
package ai.pathfinder;

import ai.pathfinder.Connector;
import java.util.ArrayList;

public class Node {
    public float x;
    public float y;
    public float z;
    public Node parent = null;
    public float f = 0.0f;
    public float g = 0.0f;
    public float h = 0.0f;
    public ArrayList links = new ArrayList();
    public boolean walkable = true;

    public Node() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Node(float x, float y) {
        this.x = x;
        this.y = y;
        this.z = 0.0f;
    }

    public Node(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Node(float[] p) {
        this.x = p[0];
        this.y = p[1];
        this.z = 0.0f;
        if (p.length > 2) {
            this.z = p[2];
        }
    }

    public Node(float x, float y, ArrayList links) {
        this.x = x;
        this.y = y;
        this.z = 0.0f;
        this.links = links;
    }

    public Node(float x, float y, float z, ArrayList links) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.links = links;
    }

    public void reset() {
        this.parent = null;
        this.h = 0.0f;
        this.g = 0.0f;
        this.f = 0.0f;
    }

    public void setG(Connector o) {
        this.g = this.parent.g + o.d;
    }

    public void setF(Node finish) {
        this.setH(finish);
        this.f = this.g + this.h;
    }

    public void setH(Node finish) {
        this.h = this.dist(finish);
    }

    public void MsetF(Node finish) {
        this.MsetH(finish);
        this.f = this.g + this.h;
    }

    public void MsetH(Node finish) {
        this.h = this.manhattan(finish);
    }

    public Node copy() {
        ArrayList temp = new ArrayList();
        temp.addAll(this.links);
        return new Node(this.x, this.y, this.z, temp);
    }

    public void connect(Node n) {
        this.links.add(new Connector(n, this.dist(n)));
    }

    public void connect(Node n, float d) {
        this.links.add(new Connector(n, d));
    }

    public void connect(ArrayList links) {
        this.links.addAll(links);
    }

    public void connectBoth(Node n) {
        this.links.add(new Connector(n, this.dist(n)));
        n.links.add(new Connector(this, this.dist(n)));
    }

    public void connectBoth(Node n, float d) {
        this.links.add(new Connector(n, d));
        n.links.add(new Connector(this, d));
    }

    public int indexOf(Node n) {
        int i = 0;
        while (i < this.links.size()) {
            Connector c = (Connector)this.links.get(i);
            if (c.n == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean connectedTo(Node n) {
        int i = 0;
        while (i < this.links.size()) {
            Connector c = (Connector)this.links.get(i);
            if (c.n == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean connectedTogether(Node n) {
        int i = 0;
        while (i < this.links.size()) {
            Connector c = (Connector)this.links.get(i);
            if (c.n == n) {
                int j = 0;
                while (j < n.links.size()) {
                    Connector o = (Connector)n.links.get(j);
                    if (o.n == this) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public void mulDist(float m) {
        int i = 0;
        while (i < this.links.size()) {
            Connector c = (Connector)this.links.get(i);
            c.d *= m;
            ++i;
        }
    }

    public void setDist(Node n, float d) {
        int i = this.indexOf(n);
        if (i > -1) {
            Connector temp = (Connector)this.links.get(i);
            temp.d = d;
        }
    }

    public void setDistBoth(Node n, float d) {
        int i = this.indexOf(n);
        if (i > -1) {
            Connector temp = (Connector)this.links.get(i);
            temp.d = d;
            int j = n.indexOf(this);
            if (j > -1) {
                temp = (Connector)n.links.get(j);
                temp.d = d;
            }
        }
    }

    public void disconnect() {
        int i = 0;
        while (i < this.links.size()) {
            Connector c = (Connector)this.links.get(i);
            int index = c.n.indexOf(this);
            if (index > -1) {
                c.n.links.remove(index);
            }
            ++i;
        }
    }

    public void radialDisconnect() {
        Connector myLink;
        float radius = 0.0f;
        int j = 0;
        while (j < this.links.size()) {
            myLink = (Connector)this.links.get(j);
            if (this.straightLink(myLink.n)) {
                radius = this.dist(myLink.n);
                break;
            }
            ++j;
        }
        j = 0;
        while (j < this.links.size()) {
            myLink = (Connector)this.links.get(j);
            ArrayList<Node> removeMe = new ArrayList<Node>();
            int k = 0;
            while (k < myLink.n.links.size()) {
                Connector myLinkLink = (Connector)myLink.n.links.get(k);
                float midX = (myLink.n.x + myLinkLink.n.x) * 0.5f;
                float midY = (myLink.n.y + myLinkLink.n.y) * 0.5f;
                float midZ = (myLink.n.z + myLinkLink.n.z) * 0.5f;
                Node temp = new Node(midX, midY, midZ);
                if (this.dist(temp) <= radius) {
                    removeMe.add(myLinkLink.n);
                }
                ++k;
            }
            k = 0;
            while (k < removeMe.size()) {
                Node temp = (Node)removeMe.get(k);
                int index = myLink.n.indexOf(temp);
                if (index > -1) {
                    myLink.n.links.remove(index);
                }
                ++k;
            }
            ++j;
        }
    }

    public boolean straightLink(Node myLink) {
        if (this.indexOf(myLink) < 0) {
            return false;
        }
        int dimDelta = 0;
        if (this.x != myLink.x) {
            ++dimDelta;
        }
        if (this.y != myLink.y) {
            ++dimDelta;
        }
        if (this.z != myLink.z) {
            ++dimDelta;
        }
        return dimDelta == 1;
    }

    public float dist(Node n) {
        if ((double)this.z == 0.0 && (double)n.z == 0.0) {
            return (float)Math.sqrt((this.x - n.x) * (this.x - n.x) + (this.y - n.y) * (this.y - n.y));
        }
        return (float)Math.sqrt((this.x - n.x) * (this.x - n.x) + (this.y - n.y) * (this.y - n.y) + (this.z - n.z) * (this.z - n.z));
    }

    public float manhattan(Node n) {
        if ((double)this.z == 0.0 && (double)n.z == 0.0) {
            return (this.x - n.x) * (this.x - n.x) + (this.y - n.y) * (this.y - n.y) + (this.z - n.z) * (this.z - n.z);
        }
        return (this.x - n.x) * (this.x - n.x) + (this.y - n.y) * (this.y - n.y);
    }
}

