import javax.swing.*;
import ai.pathfinder.*;

/**
 * Nolli plan class; please see: http://nolli.uoregon.edu/ this will explain what you can expect
 * @author: Richard Schaffranek
 * @version: 1.0
 */
public class Nolli {

  Pathfinder PATHS;
  Polygon[] SOLID;
  PVector BBmin,BBmax;
  float SP;

  /** 
   * you can only call the constructor from the main part where your setup() method is
   * this is due to the JFileChooser class used. sample code: Nolli N = new Nolli(this);
   */
  Nolli(Object parent) {
    this.SOLID =  new Polygon[0];
    this.BBmin = new PVector();
    this.BBmax = new PVector();
    this.PATHS = new Pathfinder();
    this.SP = 0;
    JFileChooser fc = new JFileChooser(); 
    int returnVal = fc.showOpenDialog((Component)parent); 
    if (returnVal == JFileChooser.APPROVE_OPTION) { 
      File file = fc.getSelectedFile(); 
      if (file.getName().endsWith("xml")) { 
        String filename = file.getPath();
        XMLElement tempXML = new XMLElement((PApplet)parent,filename);
        this.SOLID = this.build(tempXML);
      }  
    }     
    this.BBox();
  }

  /** call to set a target for the dijkstra algorithmus;
   * when called the shortest path from every Node to this Node is callculated;
   * this might take a while but can be usefule;
   * please see: http://robotacid.com/ (Documents & Code -  Pathfinder Libary)
   * @param N : Node nearest to the target
   */
  public void target (Node N ) {
    if (PATHS.nodes.size() > 0){
      PATHS.dijkstra(N);
    }
  }

  /** @retrun ArrayList of Nodes (path) from this node to the target set befor
   */
  public ArrayList path(Node N){  //RETURN PATH FROM A TO B
    if (PATHS.nodes.size() > 0){
      return PATHS.getPath(N);
    }
    return null;
  }

  /** @retrun ArrayList of Nodes (path) from the start to the target
   * @param S : starting node of the path
   * @param T : target node of the path
   */
  public ArrayList path(Node S,Node T){  //RETURN PATH FROM A TO B
    if (PATHS.nodes.size() > 0){
      return PATHS.aStar(S,T);
    }
    return null;
  }

  /** @param N : set this node unwalkable
   */
  public void unwalkable(Node N){
    if (PATHS.nodes.size() > 0){
      N.walkable = false; 
    }
  }

  /** sets all Nodes walkable
   */
  public void allWalkable() {
    Node N;
    for (int i =0; i < PATHS.nodes.size();i++){
      N = (Node) PATHS.nodes.get(i);
      N.walkable = true; 
    } 
  }

  /** get the nearest Node to a position
   */
  public Node nearest(PVector pos) { // REVISIT
    if (PATHS.nodes.size() > 0){
      Node N,N1;
      N1 = null;
      N = (Node) PATHS.nodes.get(0);
      float d = dist(N.x,N.y,pos.x,pos.y);
      for (int i = 0; i < PATHS.nodes.size();i++) {
        N = (Node) PATHS.nodes.get(i);
        if (d >= dist(N.x,N.y,pos.x,pos.y) ) {
          N1 = N;
          d = dist(N.x,N.y,pos.x,pos.y) ;
        }
      }
      return N1;
    }
    return null;
  }

  /** greates a network of nodes
   * @param sp : minimum distance between the nodes;
   */
  public void network(float sp){
    this.SP = sp;
    PATHS = new Pathfinder();
    Node TempN,TempN2; 
    Connector C;
    int count = int( (BBmax.x-BBmin.x)/this.SP * (BBmax.y-BBmin.y)/this.SP );
    PVector PV; 
    for (int i = 0; i < count*2;i++) {
      PV = new PVector(random(BBmin.x-5*this.SP,BBmax.x+5*this.SP),random(BBmin.y-5*this.SP,BBmax.y+5*this.SP));
      if (!inside(PV) && !nextTo(PV,this.SP)) PATHS.nodes.add(new Node(PV.x,PV.y));
    }// end for
    for (int i = 0; i < PATHS.nodes.size();i++) {
      TempN = (Node) PATHS.nodes.get(i);
      for (int i2 = i+1; i2 < PATHS.nodes.size();i2++) {
        TempN2 = (Node) PATHS.nodes.get(i2);
        if(i != i2 && dist(TempN.x,TempN.y,TempN2.x,TempN2.y) <= this.SP*2.5 ) {
          if (wall(TempN,TempN2)) TempN.connectBoth(TempN2);
        }
      }
    }
    float TempSP = this.SP;
    ArrayList    GRAPHEN = new ArrayList();
    ArrayList    ADDED = new ArrayList();
    ArrayList LeftOver = new ArrayList();
    while(GRAPHEN.size() < PATHS.nodes.size() && TempSP < this.SP*5){
      GRAPHEN = new ArrayList();
      LeftOver = new ArrayList();
      LeftOver.addAll(PATHS.nodes);
      TempN = (Node) PATHS.nodes.get(0);
      GRAPHEN.add(TempN);
      LeftOver.remove(0);
      for(int i = 0; i < GRAPHEN.size();i ++) {
        TempN = (Node) GRAPHEN.get(i);
        for (int ii = 0; ii < TempN.links.size();ii++) {
          C = (Connector) TempN.links.get(ii);
          if (GRAPHEN.indexOf(C.n) == -1) {
            GRAPHEN.add(C.n);
            LeftOver.remove(LeftOver.indexOf(C.n));
          }
        }
      }
      if (GRAPHEN.size() != PATHS.nodes.size()){
        for (int ii = 0; ii < LeftOver.size();ii++){
          TempN = (Node) LeftOver.get(ii);
          for(int i = 0; i < GRAPHEN.size();i ++) {
            TempN2 = (Node) GRAPHEN.get(i);
            if (dist(TempN.x,TempN.y,TempN2.x,TempN2.y) <= TempSP*3 ) {
              if (wall(TempN,TempN2)) {
                TempN.connectBoth(TempN2);
                ADDED.add(TempN);
                ADDED.add(TempN2);
              }
            }//end if
          }// end for
        }// end for
        TempSP+=this.SP;
      }//end if
    }//end while
    for (int i = 0; i< LeftOver.size();i++){
      TempN = (Node) LeftOver.get(i);
      PATHS.nodes.remove(PATHS.nodes.indexOf(TempN)); 
    }
  }

  /** @return false if there is a wall between the two nodes
   */
  public boolean wall(Node N1,Node N2) {
    PVector DIR = new PVector(N2.x-N1.x,N2.y-N1.y);
    PVector POS = new PVector(N1.x,N1.y);
    float d = DIR.mag();
    DIR.normalize();
    for (int i = 0; i < d;i++){
      if ( inside(POS) ) return false; 
      POS.add(DIR);
    }
    return true;
  }

  private boolean nextTo(PVector pos,float sp) {
    Node TempN;
    for (int i = 0; i < PATHS.nodes.size();i++){
      TempN = (Node) PATHS.nodes.get(i);
      if (dist(TempN.x,TempN.y,pos.x,pos.y) < sp) return true;
    }
    return false; 
  }

  /** @return true if the given vector is inside a wall 
   */
  public boolean inside(PVector TempV) { 
    int InSide = 0;
    for (int i = 0; i < SOLID.length;i++) {
      InSide = (SOLID[i].inside( (int)TempV.x,(int)TempV.y) ) ? InSide + 1 : InSide; 
    }
    return 1 == InSide%2;
  }

  /** call to display buildings,nodes and connections to screen
   */
  public void displayAll() {
    this.display();
    this.displayNodes();
    this.displayConnections();
  }

  /** call to display buildings
   */
  public void display() { 
    pushStyle();
    fill(0);
    stroke(0);
    for (int i = 0; i < SOLID.length;i++) {
      beginShape(); 
      for (int ip = 0; ip < SOLID[i].npoints;ip++){
        vertex(SOLID[i].xpoints[ip],SOLID[i].ypoints[ip]); 
      }
      endShape(CLOSE);
    }
    popStyle();
  }
  /** call to display nodes
  */
  public void displayNodes() {
    pushStyle();
    Node TempN;
    noFill();
    stroke(0);
    strokeWeight(0);
    for (int i =0; i < PATHS.nodes.size();i++){
      TempN = (Node) PATHS.nodes.get(i);
      ellipse(TempN.x,TempN.y,2,2);
    }
    popStyle();
  }
  /** call to display connections
  */
  public void displayConnections() {
    Node TempN;
    Connector TempC;
    pushStyle();
    stroke(165,206,46);
    strokeWeight(0);
    for (int i =0; i < PATHS.nodes.size();i++){
      TempN = (Node) PATHS.nodes.get(i);
      for (int ii = 0; ii < TempN.links.size();ii++){
        TempC = (Connector) TempN.links.get(ii);
        line(TempN.x,TempN.y,TempC.n.x,TempC.n.y);
      }
    }
    popStyle();
  }


  private void BBox() {
    BBmin = new PVector(SOLID[0].xpoints[0],SOLID[0].ypoints[0]);
    BBmax = new PVector(SOLID[0].xpoints[0],SOLID[0].ypoints[0]);    
    for (int i = 0; i < SOLID.length;i++) {
      BBmin.x = min(BBmin.x,min(SOLID[i].xpoints));
      BBmin.y = min(BBmin.y,min(SOLID[i].ypoints));
      BBmax.x = max(BBmax.x,max(SOLID[i].xpoints));
      BBmax.y = max(BBmax.y,max(SOLID[i].ypoints));
    }
  }

  private Polygon[] build(XMLElement TempLoad) {
    if (TempLoad.getChildCount() > 0) {
      if ( TempLoad.getChild(0).getStringAttribute("kind","-1").equals("Polygons") ) {
        XMLElement[] TempLL = TempLoad.getChildren();
        Polygon[] ret = new Polygon[TempLL.length-1];
        XMLElement[] PPOINTS;
        for(int i = 1; i < TempLL.length;i++) {
          PPOINTS = TempLL[i].getChildren();
          int[] x = new int[PPOINTS.length];
          int[] y = new int[PPOINTS.length];
          for(int ip = 0; ip < PPOINTS.length;ip++ ) {
            x[ip] = (int) PPOINTS[ip].getFloatAttribute("X");
            y[ip] = (int) PPOINTS[ip].getFloatAttribute("Y");
          }
          ret[i-1] = (Polygon) new Polygon(x,y,x.length);
        }
        return ret;
      }
    }
    return new Polygon[0]; 
  }

}
