/**
 * controll class to have 2D (pan && zoom) controll over the applet ..
 * @author: Richard Schaffranek
 * @version: 1.0
 */
public class View2D{

  private float V2DPX,V2DPY;
  private float V2Dsc,V2DmouseX,V2DmouseY;              
  private float VWidth,VHeight;                  
  private float[] V2DPXS,V2DPYS,V2DscStored;      
  private PFont font;                             

  View2D() {                            
    V2Dsc = 1;
    V2DPX = 0;
    V2DPY = 0;
    V2DmouseX = mouseX;
    V2DmouseY = mouseY;
    VWidth = width;
    VHeight = height;
    font = createFont("Courier",12);
    setNewView();
  }

  /**
      * @return current X mouse position in modell space
   */
  public float mouseX2D() {
    return V2DmouseX; 
  }

  /**
      * @return current Y mouse position in modell space
   */
  public float mouseY2D() {
    return V2DmouseY; 
  }

  /**
      * @return current mouse position in modell space
   */
  public PVector mouse2D() {
    return new PVector(V2DmouseX,V2DmouseY);
  }

  /**
      * @return current scale of the Modell Space
   */
  public float scale2D() {
    return V2Dsc; 
  }  

  /**
   * get current Width of the Modell Space displayed
   */
  public float Width2D() {
    return VWidth; 
  }
  /**
      * @return current Height of the Modell Space displayed
   */
  public float Height2D() {
    return VHeight; 
  }

  /** rescale the view so that the evrything between the given koordinates is displayed
   * @param BBmax : maximum
   * @param BBmin : minimum
   */
  public void rescale (PVector BBmax,PVector BBmin) {
    V2Dsc = min(width/abs(BBmin.x-BBmax.x),height/abs(BBmin.y-BBmax.y)); 
    V2Dsc = max(V2Dsc,.01); 
    V2DPX =  width/2F  - (BBmax.x+BBmin.x)/2F;
    V2DPY =  height/2F - (BBmax.y+BBmin.y)/2F;
    setNewView();
  }

  /** call to display stored views
   */
  public void displayMenu() {
    pushStyle();                                                     
    fill(255,200);
    noStroke();                                                      
    rect(0,0,width,15);
    fill(0);                                                         
    textFont(font);                                                  
    for (int i = 0; i < V2DPXS.length;i++) {                         
      text(i+1,2+i*10 ,12);                                          
    } 
    popStyle();
  }

  /** Call to switch from screen to model space
   */
  public void pushView() {                                             // function to call at the beginning to initialize the modell space
    V2DmouseX = width/2F  - V2DPX + (-width/2F  + mouseX) / V2Dsc;     // callculate mouse position in X in modell space 
    V2DmouseY = height/2F - V2DPY + (-height/2F + mouseY) / V2Dsc;     // callculate mouse position in Y in modell space 
    VWidth = width  / V2Dsc;                                           // callculate modell V2Dscreen width in modell space
    VHeight = height / V2Dsc;                                          // callculate modell V2Dscreen height in modell space
    translate(width/2F,height/2F);                                     // translate origin to midel of V2Dscreen
    scale(V2Dsc);                                                      // V2Dscale from the midel the V2Dscreen
    translate(-width/2F,-height/2F);                                   // translate origin to original position of the V2Dscreen
    translate (V2DPX,V2DPY);                                           // translate origin to paned positon  
  }

  /** Call to pan and zoom 
   *   'alt' = zoom
   *   'shift' = pan
      * @return true if aktion happens
   */
  public boolean panZoom() {                                              // Call this function in the mouseDragged void, checks for key events!
    if (keyCode == ALT) {                                              // if the 'ALT' key is pressed
      V2Dsc += (mouseY - pmouseY)*.01;                                 // V2Dscale position based upon mouse movment
      V2Dsc = max(V2Dsc,.01);                                          // prefent form V2Dscaling to fare away
      return true;
    }
    else if (keyCode == SHIFT) {                                       // if the 'SHIFT' key is pressed
      V2DPX += (mouseX - pmouseX)/V2Dsc;                               // changes to X pan based upon mouse movment 
      V2DPY += (mouseY - pmouseY)/V2Dsc;                               // changes to Y pan based upon mouse movment 
      return true;
    }
    return false;
  }

  /** Call this function in the keyReleased void 
   * to reset the key && keycode variables to 0. 
   * This doesn't happen automaticly!
   */
  public void resetKey() {               
    key = 0;                                                           // reset key variable to '0'
    keyCode = 0;                                                       // reste keycode variable '0'
  }

  /** user controll to access and store views
   * preset keys :
   * 'S' to save view
   * 'R' to delete all saved views
   * 1 - 9 to access saved views
   */
  public void keyPress(char k) {               
    if (k == 'S') {                                                  // Store view
      if (V2DPXS.length < 7) {                                         // Only allows Storying 7 Views
        V2DPXS = (float[]) append(V2DPXS,V2DPX);                       // append float[] Array
        V2DPYS = (float[]) append(V2DPYS,V2DPY);                       // append float[] Array
        V2DscStored = (float[]) append(V2DscStored,V2Dsc);                           // append float[] Array
      }
    }
    else if(k == 'R') {                                                           // Reset Views
      setNewView();                                                              // call the SET_NEW_VIEWS() method of this class
    }
    else if (57 >= int(key) && int(key) >= 49 && V2DPXS.length > int(key)-49 ){     // switch to selected view the -49 is because the number 49 represents the keyboard key 0 
      V2DPX = V2DPXS[int(key)-49];             
      V2DPY = V2DPYS[int(key)-49];
      V2Dsc = V2DscStored[int(key)-49];
    }
  }

  /** call to display courser in view 
   *   and 0,0 point 
   */
  public void display(){
    noCursor();     
    pushStyle();
    noFill();
    stroke(0); 
    strokeWeight(1/V2Dsc);
    line(0,-height/(18F*V2Dsc),0,height/(6F*V2Dsc) );
    line(-width/(18F*V2Dsc),0,width/(6F*V2Dsc),0);
    // render current Mouse Cursor in Modell Space
    pushMatrix();            
    translate(V2DmouseX,V2DmouseY);
    stroke(255,0,0);
    line(-8/V2Dsc,0,0,0);
    line(0,0,20/V2Dsc,0);
    stroke(0,255,0);
    line(0,-8/V2Dsc,0,0);
    line(0,0,0,20/V2Dsc);
    popMatrix();     
    popStyle();
  }

  private void setNewView() {
    V2DPXS = new float[1];                                             // iniialize float array
    V2DPXS[0] = V2DPX;                                                     // set first element of the float array
    V2DPYS = new float[1];                                             // iniialize float array
    V2DPYS[0] = V2DPY;                                                     // set first element of the float array
    V2DscStored = new float[1];                                        // iniialize float array
    V2DscStored[0] = V2Dsc;                                                // set first element of the float array
  }
}






